/*
*  DJPEG.H  - Decode JPEG File Header
*/
#ifndef  _DJPEG_H_
#define  _DJPEG_H_

#ifdef __cplusplus
extern "C"
{
#endif


#define  DJPEGERR_NONE           0
#define  DJPEGERR_NOT256GRAY     1     // not 256 shades of gray JFIF
#define  DJPEGERR_IMAGEBIG       2     // expanded image > 65,000 bytes
#define  DJPEGERR_MALLOC         3     // memory allocation error
#define  DJPEGERR_COLORMAP       4     // attempt to quantize colors?
#define  DJPEGERR_NOTGRAYSCALE   5     // not a grayscale JFIF

#define  DJPEGERR_MAXID          5
#define  DJPEGERR_UNKNOWN        (DJPEGERR_MAXID+1) // internal library error

/*
*  decodeJFIF
*
*  hJFIF    handle to global memory block which contains JFIF image
*  phDIB    returned global memory handle of DIB image output
*
*  Returns  Return a zero if successful; a positive error code if fails.
*/
size_t decodeJFIF( unsigned char * lpJFIF, size_t nJFIFLen, HGLOBAL *phDIB );
void freeJFIFbmp(HGLOBAL hDIB);


#ifdef __cplusplus
}
#endif


#endif
